"""Tie-kernel helpers (exposed for testing)."""
from __future__ import annotations
import numpy as np

def primitive_kernel(n: int, eta: float = 1e-6) -> np.ndarray:
    A = np.ones((n, n), dtype=float) - np.eye(n, dtype=float)
    return A + eta * np.eye(n, dtype=float)
